/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.MacButtonFactory;
import com.explodingpixels.macwidgets.SourceListControlBar;
import com.explodingpixels.macwidgets.TriAreaComponent;
import com.explodingpixels.widgets.PopdownButton;
import com.explodingpixels.widgets.PopupMenuCustomizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;

public class ComponentBottomBar
extends TriAreaComponent {
    protected static final ImageIcon SPLITTER_HANDLE = new ImageIcon(SourceListControlBar.class.getResource("/com/explodingpixels/macwidgets/images/splitter_handle.png"));
    protected JSplitPane fSplitPane;
    protected final JLabel fSplitterHandle = new JLabel(SPLITTER_HANDLE);
    protected final SplitterHandleMouseMovementHandler fMouseListener = new SplitterHandleMouseMovementHandler();

    public ComponentBottomBar() {
        this.setBackgroundPainter(MacButtonFactory.GRADIENT_BUTTON_IMAGE_PAINTER);
        this.getComponent().setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, MacButtonFactory.GRADIENT_BUTTON_BORDER_COLOR));
    }

    public void addComponentToLeftWithBorder(JComponent toolToAdd) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, MacButtonFactory.GRADIENT_BUTTON_BORDER_COLOR));
        panel.add((Component)toolToAdd, "Center");
        super.addComponentToLeft(panel);
    }

    public void addComponentToCenterWithBorder(JComponent toolToAdd) {
        MatteBorder matteBorder = this.getCenterComponentCount() == 0 ? BorderFactory.createMatteBorder(0, 1, 0, 1, MacButtonFactory.GRADIENT_BUTTON_BORDER_COLOR) : BorderFactory.createMatteBorder(0, 0, 0, 1, MacButtonFactory.GRADIENT_BUTTON_BORDER_COLOR);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, MacButtonFactory.GRADIENT_BUTTON_BORDER_COLOR));
        panel.add((Component)toolToAdd, "Center");
        super.addComponentToCenter(panel);
    }

    public void addComponentToRightWithBorder(JComponent toolToAdd) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, MacButtonFactory.GRADIENT_BUTTON_BORDER_COLOR));
        panel.add((Component)toolToAdd, "Center");
        super.addComponentToRight(panel);
    }

    public void installDraggableWidgetOnSplitPane(JSplitPane splitPane) {
        if (splitPane == null) {
            throw new IllegalArgumentException("JSplitPane cannot be null.");
        }
        this.fSplitPane = splitPane;
        this.fSplitterHandle.addMouseListener(this.fMouseListener);
        this.fSplitterHandle.addMouseMotionListener(this.fMouseListener);
        this.addComponentToRight(this.fSplitterHandle);
        this.fSplitterHandle.setCursor(Cursor.getPredefinedCursor(10));
    }

    public PopdownButton createAndAddPopdownButton(Icon icon, PopupMenuCustomizer popupMenuCustomizer) {
        PopdownButton button = MacButtonFactory.createGradientPopdownButton(icon, popupMenuCustomizer);
        ComponentBottomBar.initBottomBarButton(button.getComponent());
        this.addComponentToLeft(button.getComponent());
        return button;
    }

    public JComponent createAndAddButton(Icon icon, ActionListener actionListener) {
        JComponent button = MacButtonFactory.createGradientButton(icon, actionListener);
        ComponentBottomBar.initBottomBarButton(button);
        this.addComponentToLeft(button);
        return button;
    }

    static void initBottomBarButton(JComponent component) {
        component.setBorder(BorderFactory.createEmptyBorder());
    }

    public void hideResizeHandle() {
        this.fSplitterHandle.setVisible(false);
    }

    protected class SplitterHandleMouseMovementHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private int fDelta;

        protected SplitterHandleMouseMovementHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MouseEvent convertedEvent = SwingUtilities.convertMouseEvent(ComponentBottomBar.this.fSplitterHandle, e, ComponentBottomBar.this.fSplitPane);
            this.fDelta = ComponentBottomBar.this.fSplitPane.getDividerLocation() - convertedEvent.getPoint().x;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MouseEvent convertedEvent = SwingUtilities.convertMouseEvent(ComponentBottomBar.this.fSplitterHandle, e, ComponentBottomBar.this.fSplitPane);
            int newLocation = convertedEvent.getPoint().x + this.fDelta;
            int boundedNewLocation = Math.max(ComponentBottomBar.this.fSplitPane.getMinimumDividerLocation(), Math.min(newLocation, ComponentBottomBar.this.fSplitPane.getMaximumDividerLocation()));
            ComponentBottomBar.this.fSplitPane.setDividerLocation(boundedNewLocation);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

