/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenBlacklist;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.gui.MVFilter;
import mediathek.gui.MVFilterFrame;
import mediathek.gui.MVFilterPanel;
import mediathek.gui.MVStatusBar;
import mediathek.gui.PanelFilmBeschreibung;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogAddDownload;
import mediathek.gui.dialog.DialogEditAbo;
import mediathek.gui.dialog.MVFilmInfo;
import mediathek.res.GetIcon;
import mediathek.tool.BeobTableHeader;
import mediathek.tool.CellRendererFilme;
import mediathek.tool.Filter;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.HinweisKeineAuswahl;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVListeFilme;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MVTable;
import mediathek.tool.TModel;
import mediathek.tool.TModelFilm;
import msearch.daten.DatenFilm;
import msearch.daten.ListeFilme;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;
import msearch.tool.Datum;

public class GuiFilme
extends PanelVorlage {
    private JButton[] buttonArray;
    private final String[] COMBO_ZEIT = new String[]{"alles", "1 Tag", "2 Tage", "3 Tage", "7 Tage", "15 Tage", "20 Tage", "30 Tage"};
    public static final int[] COMBO_ZEIT_INT = new int[]{0, 1, 2, 3, 7, 15, 20, 30};
    private static final int FILTER_ZEIT_STARTWERT = 5;
    private static final int FILTER_DAUER_STARTWERT = 0;
    private final MVFilmInfo filmInfo;
    private final PanelFilmBeschreibung panelBeschreibung;
    private MVFilter mVFilter;
    public MVFilterFrame mVFilterFrame;
    private final MVFilterPanel mVFilterPanel;
    private JCheckBox jCheckBoxProgamme;
    private JPanel jPanelBeschreibung;
    private JPanel jPanelExtra;
    private JPanel jPanelExtraInnen;
    private JPanel jPanelFilter;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneFilter;
    private JSplitPane jSplitPane1;

    public GuiFilme(Daten d, JFrame parentComponent) {
        super(d, parentComponent);
        this.initComponents();
        this.tabelle = new MVTable(0);
        this.jScrollPane1.setViewportView(this.tabelle);
        this.jScrollPaneFilter.getVerticalScrollBar().setUnitIncrement(16);
        this.panelVideoplayerSetzen();
        this.panelBeschreibung = new PanelFilmBeschreibung(this.daten.mediathekGui, this.daten);
        this.mVFilterPanel = new MVFilterPanel(parentComponent, this.daten){

            @Override
            public void mvFfilter(int i) {
                GuiFilme.this.filter(i);
            }

            @Override
            public void mvFdeleteFilter(int i) {
                GuiFilme.this.delFilterProfile(i);
            }

            @Override
            public void mvFsaveFilter(int i) {
                GuiFilme.this.saveFilterProfile(i);
            }
        };
        this.mVFilterFrame = new MVFilterFrame(d){

            @Override
            public void mvFfilter(int i) {
                GuiFilme.this.filter(i);
            }

            @Override
            public void mvFdeleteFilter(int i) {
                GuiFilme.this.delFilterProfile(i);
            }

            @Override
            public void mvFsaveFilter(int i) {
                GuiFilme.this.saveFilterProfile(i);
            }
        };
        this.jPanelBeschreibung.setLayout(new BorderLayout());
        this.jPanelBeschreibung.add((Component)this.panelBeschreibung, "Center");
        this.jPanelFilter.setLayout(new BorderLayout());
        this.filmInfo = this.daten.filmInfo;
    }

    @Override
    public void isShown() {
        super.isShown();
        this.daten.mediathekGui.setToolbar("Tab-Filme");
        this.daten.mediathekGui.getStatusBar().setIndexForLeftDisplay(MVStatusBar.StatusbarIndex.FILME);
        this.aktFilmSetzen();
        this.setInfo();
    }

    public void guiFilmeFilmAbspielen() {
        this.playFilm();
    }

    public void guiFilmeFilmSpeichern() {
        this.saveFilm();
    }

    public void guiFilmMediensammlung() {
        this.mediensammlung();
    }

    public void guiFilmeFilterLoeschen() {
        this.delFilter();
    }

    public void guiFilmeFiltern() {
        this.loadTable();
    }

    public void searchUrl(String url) {
        this.searchUrl_(url);
    }

    public void filmGesehen() {
        this.daten.history.setGesehen(true, this.getSelFilme());
    }

    public void filmUngesehen() {
        this.daten.history.setGesehen(false, this.getSelFilme());
    }

    public void init() {
        this.panelBeschreibungSetzen();
        Daten.filmeLaden.addAdListener(new MSListenerFilmeLaden(){

            public void start(MSListenerFilmeLadenEvent event) {
                GuiFilme.this.mVFilter.enableFilter(false);
                GuiFilme.this.loadTable();
            }

            public void fertig(MSListenerFilmeLadenEvent event) {
                GuiFilme.this.loadTable();
                GuiFilme.this.mVFilter.enableFilter(true);
            }
        });
        this.daten.mediathekGui.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "sender");
        this.daten.mediathekGui.getRootPane().getActionMap().put("sender", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowSorter.SortKey sk = new RowSorter.SortKey(1, SortOrder.ASCENDING);
                LinkedList<RowSorter.SortKey> listSortKeys = new LinkedList<RowSorter.SortKey>();
                listSortKeys.add(sk);
                GuiFilme.this.tabelle.getRowSorter().setSortKeys(listSortKeys);
                GuiFilme.this.tabelle.requestFocusSelelct(GuiFilme.this.jScrollPane1, 0);
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "abspielen");
        this.getActionMap().put("abspielen", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFilme.this.playFilm();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "download");
        this.getActionMap().put("download", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFilme.this.saveFilm();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "tabelle");
        this.getActionMap().put("tabelle", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFilme.this.tabelle.requestFocusSelelct(GuiFilme.this.jScrollPane1);
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "info");
        this.getActionMap().put("info", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GuiFilme.this.filmInfo.isVisible()) {
                    GuiFilme.this.filmInfo.showInfo();
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "url-copy");
        this.getActionMap().put("url-copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatenFilm film = GuiFilme.this.getSelFilm();
                if (film != null) {
                    GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung("normal"));
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "url-hd-copy");
        this.getActionMap().put("url-hd-copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatenFilm film = GuiFilme.this.getSelFilm();
                if (film != null) {
                    GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung("hd"));
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "url-k-copy");
        this.getActionMap().put("url-k-copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatenFilm film = GuiFilme.this.getSelFilm();
                if (film != null) {
                    GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung("klein"));
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "mediensammlung");
        this.getActionMap().put("mediensammlung", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatenFilm film = GuiFilme.this.getSelFilm();
                if (film != null) {
                    Daten.mVConfig.add("Media_DB_Dialog-anzeigen", Boolean.TRUE.toString());
                    GuiFilme.this.daten.dialogMediaDB.setVis();
                    GuiFilme.this.daten.dialogMediaDB.setFilter(film.arr[3]);
                }
            }
        });
        ActionMap am = this.tabelle.getActionMap();
        InputMap im = this.tabelle.getInputMap();
        im.put(KeyStroke.getKeyStroke(10, 0), "film_starten");
        am.put("film_starten", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFilme.this.playFilm();
            }
        });
        this.tabelle.setModel(new TModelFilm(new Object[0][], DatenFilm.COLUMN_NAMES));
        BeobMausTabelle beobMausTabelle = new BeobMausTabelle();
        this.tabelle.addMouseListener(beobMausTabelle);
        this.tabelle.getSelectionModel().addListSelectionListener(new BeobachterTableSelect());
        CellRendererFilme cellRenderer = new CellRendererFilme(this.daten);
        this.tabelle.setDefaultRenderer(Object.class, cellRenderer);
        this.tabelle.setDefaultRenderer(Datum.class, cellRenderer);
        this.tabelle.setDefaultRenderer(Integer.class, cellRenderer);
        this.tabelle.getTableHeader().addMouseListener(new BeobTableHeader(this.tabelle, DatenFilm.COLUMN_NAMES, DatenFilm.spaltenAnzeigen, new int[]{4, 5, 24, 25}, new int[]{4, 5}, true));
        this.jCheckBoxProgamme.setIcon(GetIcon.getProgramIcon("close_15.png"));
        this.jCheckBoxProgamme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("system-panel-videoplayer-anzeigen", Boolean.FALSE.toString());
                GuiFilme.this.daten.mediathekGui.videoplayerAnzeigen(true);
                GuiFilme.this.panelVideoplayerSetzen();
            }
        });
        this.setSplitPane();
        this.jSplitPane1.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (GuiFilme.this.jScrollPaneFilter.isVisible()) {
                    Daten.mVConfig.add("system-panel-filme-divider", String.valueOf(GuiFilme.this.jSplitPane1.getDividerLocation()));
                }
            }
        });
        this.setFilterPanel();
        MVListeFilme.checkBlacklist();
        this.loadTable();
        this.tabelle.initTabelle();
        if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
        this.addMVListener();
    }

    public int getTableRowCount() {
        if (this.tabelle != null) {
            return this.tabelle.getModel().getRowCount();
        }
        return 0;
    }

    private void addMVListener() {
        ListenerMediathekView.addListener(new ListenerMediathekView(3, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.panelVideoplayerSetzen();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(2, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                if (GuiFilme.this.mVFilter.get_jCheckBoxKeineGesehenen().isSelected() || GuiFilme.this.mVFilter.get_jToggleButtonHistory().isSelected()) {
                    GuiFilme.this.loadTable();
                } else {
                    GuiFilme.this.tabelle.fireTableDataChanged(true);
                }
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(10, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.loadTable();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(32, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.loadTable();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(39, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.loadTable();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(5, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                MVListeFilme.checkBlacklist();
                GuiFilme.this.loadTable();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(15, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.tabelle.fireTableDataChanged(true);
                GuiFilme.this.setInfo();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(31, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                MVListeFilme.checkBlacklist();
                GuiFilme.this.loadTable();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(new int[]{14, 9}, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.setInfo();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(23, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.setFilterPanel();
                MVListeFilme.checkBlacklist();
                GuiFilme.this.loadTable();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(25, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.panelBeschreibungSetzen();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(26, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                if (Boolean.parseBoolean(Daten.mVConfig.get("Vis-Filter"))) {
                    GuiFilme.this.mVFilter.get_jTextFieldFilterThemaTitel().requestFocus();
                    GuiFilme.this.mVFilter.get_jTextFieldFilterThemaTitel().setCaretPosition(0);
                }
            }
        });
    }

    private void panelBeschreibungSetzen() {
        this.jPanelBeschreibung.setVisible(Boolean.parseBoolean(Daten.mVConfig.get("system-panel-beschreibung-anzeigen")));
    }

    private synchronized void playFilm() {
        DatenPset pset = Daten.listePset.getPsetAbspielen();
        if (pset != null) {
            this.playerStarten(pset);
        } else {
            MVMessageDialog.showMessageDialog(this.parentComponent, "Im Men\u00fc unter \"Datei->Einstellungen->Set bearbeiten\" ein Programm zum Abspielen festlegen.", "kein Videoplayer!", 1);
        }
    }

    private synchronized void saveFilm() {
        this.saveFilm(null);
    }

    private synchronized void saveFilm(DatenPset pSet) {
        if (Daten.listePset.getListeSpeichern().isEmpty()) {
            MVMessageDialog.showMessageDialog(this.parentComponent, "Im Men\u00fc unter \"Datei->Einstellungen->Set bearbeiten\" ein Programm zum Aufzeichnen festlegen.", "fehlende Einstellungen zum Speichern!", 1);
            return;
        }
        ArrayList<DatenFilm> liste = this.getSelFilme();
        for (DatenFilm datenFilm : liste) {
            int ret;
            DatenDownload datenDownload = Daten.listeDownloads.getDownloadUrlFilm(datenFilm.arr[12]);
            if (datenDownload != null && (ret = JOptionPane.showConfirmDialog(this.parentComponent, "Download f\u00fcr den Film existiert bereits.\nNochmal anlegen?", "Anlegen?", 0)) != 0) continue;
            String aufloesung = "";
            if (this.mVFilter.get_jCheckBoxNurHd().isSelected()) {
                aufloesung = "hd";
            }
            DialogAddDownload dialog = new DialogAddDownload(this.daten.mediathekGui, this.daten, datenFilm, pSet, aufloesung);
            dialog.setVisible(true);
        }
    }

    private void playerStarten(DatenPset pSet) {
        if (this.tabelle.getSelectedRow() == -1) {
            new HinweisKeineAuswahl().zeigen(this.parentComponent);
        } else if (pSet.istSpeichern()) {
            this.saveFilm(pSet);
        } else {
            String aufloesung = "";
            if (this.mVFilter.get_jCheckBoxNurHd().isSelected()) {
                aufloesung = "hd";
            }
            this.daten.starterClass.urlMitProgrammStarten(pSet, this.getSelFilm(), aufloesung);
        }
    }

    private void mediensammlung() {
        DatenFilm film = this.getSelFilm();
        if (film != null) {
            Daten.mVConfig.add("Media_DB_Dialog-anzeigen", Boolean.TRUE.toString());
            this.daten.dialogMediaDB.setVis();
            this.daten.dialogMediaDB.setFilter(film.arr[3]);
        }
    }

    private void aktFilmSetzen() {
        if (this.isShowing()) {
            DatenFilm aktFilm = new DatenFilm();
            DatenFilm film = this.getSelFilm();
            if (film != null) {
                aktFilm = film;
            }
            this.filmInfo.updateCurrentFilm(aktFilm);
            this.panelBeschreibung.setAktFilm(aktFilm);
        }
    }

    private DatenFilm getSelFilm() {
        int selectedTableRow = this.tabelle.getSelectedRow();
        if (selectedTableRow >= 0) {
            return (DatenFilm)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(selectedTableRow), 25);
        }
        return null;
    }

    private DatenFilm getFilm(int zeileTabelle) {
        if (zeileTabelle >= 0 && zeileTabelle < this.tabelle.getRowCount()) {
            return (DatenFilm)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(zeileTabelle), 25);
        }
        return null;
    }

    private void setInfo() {
        this.daten.mediathekGui.getStatusBar().setTextForLeftDisplay();
    }

    private ArrayList<DatenFilm> getSelFilme() {
        ArrayList<DatenFilm> arrayFilme = new ArrayList<DatenFilm>();
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            for (int row : rows) {
                DatenFilm datenFilm = (DatenFilm)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(row), 25);
                arrayFilme.add(datenFilm);
            }
        } else {
            new HinweisKeineAuswahl().zeigen(this.parentComponent);
        }
        return arrayFilme;
    }

    private void panelVideoplayerSetzen() {
        this.jPanelExtraInnen.removeAll();
        this.jPanelExtraInnen.updateUI();
        ListePset listeButton = Daten.listePset.getListeButton();
        int maxSpalten = 4;
        this.buttonArray = new JButton[listeButton.size()];
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.fill = 2;
        c.insets = new Insets(4, 10, 4, 10);
        this.jPanelExtraInnen.setLayout(gridbag);
        int spalte = 0;
        int zeile = 0;
        for (int i = 0; i < listeButton.size(); ++i) {
            if (!((DatenPset)listeButton.get(i)).isFreeLine()) {
                this.addExtraFeld(i, spalte, zeile, gridbag, c, this.jPanelExtraInnen, listeButton);
            }
            if (++spalte <= maxSpalten - 1) continue;
            spalte = 0;
            ++zeile;
        }
        c.weightx = 10.0;
        c.gridx = maxSpalten + 1;
        c.gridy = 0;
        JLabel label = new JLabel();
        gridbag.setConstraints(label, c);
        this.jPanelExtraInnen.add(label);
        this.jPanelExtra.setVisible(Boolean.parseBoolean(Daten.mVConfig.get("system-panel-videoplayer-anzeigen")));
    }

    private Component addExtraFeld(int i, int spalte, int zeile, GridBagLayout gridbag, GridBagConstraints c, JPanel panel, ListePset liste) {
        JComponent ret;
        c.gridx = spalte;
        c.gridy = zeile;
        if (((DatenPset)liste.get(i)).isLable()) {
            JLabel label = new JLabel(((DatenPset)liste.get((int)i)).arr[0]);
            Color col = ((DatenPset)liste.get(i)).getFarbe();
            if (col != null) {
                label.setForeground(col);
            }
            gridbag.setConstraints(label, c);
            panel.add(label);
            ret = label;
        } else {
            JButton button = new JButton(((DatenPset)liste.get((int)i)).arr[0]);
            button.addActionListener(new BeobOpen((DatenPset)liste.get(i)));
            Color col = ((DatenPset)liste.get(i)).getFarbe();
            if (col != null) {
                button.setBackground(col);
            }
            this.buttonArray[i] = button;
            gridbag.setConstraints(button, c);
            panel.add(button);
            ret = button;
        }
        return ret;
    }

    private void searchUrl_(String url) {
        url = url.trim();
        TModelFilm m = (TModelFilm)this.tabelle.getModel();
        for (int i = 0; i < m.getRowCount(); ++i) {
            if (url.equals(m.getValueAt(i, 12).toString())) continue;
            m.removeRow(i);
            --i;
        }
    }

    private void setFilterPanel() {
        boolean history = false;
        if (this.mVFilter != null) {
            this.mVFilter.removeAllListener();
            history = this.mVFilter.get_jToggleButtonHistory().isSelected();
        }
        if (Boolean.parseBoolean(Daten.mVConfig.get("Fenster-Filter"))) {
            this.jPanelFilter.removeAll();
            this.jScrollPaneFilter.setVisible(false);
            this.mVFilter = this.mVFilterFrame;
            this.mVFilterFrame.setVisible(Boolean.parseBoolean(Daten.mVConfig.get("Vis-Filter")));
        } else {
            this.mVFilterFrame.setVisible(false);
            this.mVFilter = this.mVFilterPanel;
            this.jPanelFilter.add((Component)this.mVFilterPanel, "Center");
            this.jScrollPaneFilter.setVisible(Boolean.parseBoolean(Daten.mVConfig.get("Vis-Filter")));
            if (this.jScrollPaneFilter.isVisible()) {
                this.setSplitPane();
            }
        }
        this.mVFilter.setVisible(Boolean.parseBoolean(Daten.mVConfig.get("Vis-Filter")));
        this.mVFilter.get_jComboBoxZeitraum().setModel(new DefaultComboBoxModel<String>(this.COMBO_ZEIT));
        this.mVFilter.get_jComboBoxFilterSender().setModel(new DefaultComboBoxModel<String>(Daten.listeFilmeNachBlackList.sender));
        this.mVFilter.get_jComboBoxFilterThema().setModel(new DefaultComboBoxModel<String>(this.getThemen("")));
        this.mVFilter.get_jToggleButtonHistory().setSelected(history);
        try {
            this.mVFilter.get_jComboBoxZeitraum().setSelectedIndex(Integer.parseInt(Daten.mVConfig.get("filter-tage-start")));
        }
        catch (Exception ignored) {
            this.mVFilter.get_jComboBoxZeitraum().setSelectedIndex(5);
        }
        this.mVFilter.get_jSliderMinuten().setValue(0);
        this.mVFilter.get_jTextFieldFilterMinuten().setText(String.valueOf(this.mVFilter.get_jSliderMinuten().getValue()));
        this.setFilterAction();
        this.updateUI();
    }

    private void setSplitPane() {
        try {
            this.jSplitPane1.setDividerLocation(Integer.parseInt(Daten.mVConfig.get("system-panel-filme-divider")));
        }
        catch (Exception ignore) {
            Daten.mVConfig.add("system-panel-filme-divider", "260");
            this.jSplitPane1.setDividerLocation(Integer.parseInt("260"));
        }
    }

    private void setFilterAction() {
        this.mVFilter.get_jComboBoxZeitraum().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("filter-tage-start", String.valueOf(GuiFilme.this.mVFilter.get_jComboBoxZeitraum().getSelectedIndex()));
                if (!GuiFilme.this.stopBeob) {
                    MVListeFilme.checkBlacklist();
                    GuiFilme.this.loadTable();
                }
            }
        });
        this.mVFilter.get_jToggleButtonLivestram().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GuiFilme.this.stopBeob) {
                    GuiFilme.this.stopBeob = true;
                    GuiFilme.this.mVFilter.get_jComboBoxFilterSender().setModel(new DefaultComboBoxModel<String>(Daten.listeFilmeNachBlackList.sender));
                    GuiFilme.this.mVFilter.get_jComboBoxFilterThema().setModel(new DefaultComboBoxModel<String>(GuiFilme.this.getThemen("")));
                    GuiFilme.this.mVFilter.get_jTextFieldFilterTitel().setText("");
                }
                GuiFilme.this.loadTable();
            }
        });
        this.mVFilter.get_jButtonFilterLoeschen().addActionListener(new BeobFilterLoeschen());
        this.mVFilter.get_jComboBoxFilterSender().addActionListener(new BeobFilter());
        this.mVFilter.get_jComboBoxFilterThema().addActionListener(new BeobFilter());
        this.mVFilter.get_jTextFieldFilterTitel().addActionListener(new BeobFilter());
        this.mVFilter.get_jTextFieldFilterTitel().getDocument().addDocumentListener(new BeobFilterTitelDoc());
        this.mVFilter.get_jTextFieldFilterThemaTitel().addActionListener(new BeobFilter());
        this.mVFilter.get_jTextFieldFilterThemaTitel().getDocument().addDocumentListener(new BeobFilterTitelDoc());
        this.mVFilter.get_jSliderMinuten().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!GuiFilme.this.stopBeob) {
                    GuiFilme.this.mVFilter.get_jTextFieldFilterMinuten().setText(String.valueOf(GuiFilme.this.mVFilter.get_jSliderMinuten().getValue()));
                    if (!GuiFilme.this.mVFilter.get_jSliderMinuten().getValueIsAdjusting()) {
                        GuiFilme.this.loadTable();
                    }
                }
            }
        });
        this.mVFilter.get_jCheckBoxKeineAbos().addActionListener(new BeobFilter());
        this.mVFilter.get_jCheckBoxKeineGesehenen().addActionListener(new BeobFilter());
        this.mVFilter.get_jCheckBoxNurHd().addActionListener(new BeobFilter());
        this.mVFilter.get_jCheckBoxNeue().addActionListener(new BeobFilter());
        this.mVFilter.get_jToggleButtonHistory().addActionListener(new BeobFilter());
        this.mVFilter.get_jRadioButtonTT().addActionListener(new BeobFilter());
        this.mVFilter.get_JRadioButtonIrgendwo().addActionListener(new BeobFilter());
    }

    private void filter(int filter) {
        this.stopBeob = true;
        boolean ge\u00e4ndert = false;
        try {
            this.mVFilter.get_jTextFieldFilterTitel().setText(Daten.mVConfig.get("filter-titel", filter));
            this.mVFilter.get_jTextFieldFilterThemaTitel().setText(Daten.mVConfig.get("filter-themaTitel", filter));
            if (Daten.mVConfig.get("filter-TT-oder-irgendwo", filter).isEmpty()) {
                Daten.mVConfig.add("filter-TT-oder-irgendwo", Boolean.TRUE.toString(), filter, 5);
            }
            this.mVFilter.setThemaTitel(Boolean.parseBoolean(Daten.mVConfig.get("filter-TT-oder-irgendwo", filter)));
            this.mVFilter.get_jCheckBoxKeineAbos().setSelected(Boolean.parseBoolean(Daten.mVConfig.get("filter-keineAbo", filter)));
            this.mVFilter.get_jCheckBoxKeineGesehenen().setSelected(Boolean.parseBoolean(Daten.mVConfig.get("filter-keineGesehen", filter)));
            this.mVFilter.get_jCheckBoxNurHd().setSelected(Boolean.parseBoolean(Daten.mVConfig.get("filter-nurHd", filter)));
            this.mVFilter.get_jCheckBoxNeue().setSelected(Boolean.parseBoolean(Daten.mVConfig.get("filter-nurNeue", filter)));
            this.mVFilter.get_jComboBoxZeitraum().setSelectedIndex(Integer.parseInt(Daten.mVConfig.get("filter-tage", filter)));
            if (Boolean.parseBoolean(Daten.mVConfig.get("filter-blacklist-aus", filter)) != Boolean.parseBoolean(Daten.mVConfig.get("Blacklist-ausgeschaltet"))) {
                ge\u00e4ndert = true;
                Daten.mVConfig.add("Blacklist-ausgeschaltet", Daten.mVConfig.get("filter-blacklist-aus", filter));
            }
        }
        catch (NumberFormatException ex) {
            this.mVFilter.get_jComboBoxZeitraum().setSelectedIndex(5);
            Daten.mVConfig.add("filter-tage", "5", filter, 5);
        }
        try {
            this.mVFilter.get_jSliderMinuten().setValue(Integer.parseInt(Daten.mVConfig.get("filter-dauer", filter)));
        }
        catch (Exception ex) {
            this.mVFilter.get_jSliderMinuten().setValue(0);
            Daten.mVConfig.add("filter-dauer", "0", filter, 5);
        }
        this.mVFilter.get_jTextFieldFilterMinuten().setText(String.valueOf(this.mVFilter.get_jSliderMinuten().getValue()));
        MVListeFilme.checkBlacklist();
        this.mVFilter.get_jComboBoxFilterSender().setModel(new DefaultComboBoxModel<String>(Daten.listeFilmeNachBlackList.sender));
        this.mVFilter.get_jComboBoxFilterThema().setModel(new DefaultComboBoxModel<String>(this.getThemen("")));
        this.mVFilter.get_jComboBoxFilterSender().setSelectedItem(Daten.mVConfig.get("filter-sender", filter));
        this.mVFilter.get_jComboBoxFilterThema().setSelectedItem(Daten.mVConfig.get("filter-thema", filter));
        this.stopBeob = false;
        if (ge\u00e4ndert) {
            ListenerMediathekView.notify(39, GuiFilme.class.getSimpleName());
        }
        this.loadTable();
        this.tabelle.setSelRow(0);
    }

    private void delFilter() {
        this.stopBeob = true;
        this.delFilter_();
        this.stopBeob = false;
        MVListeFilme.checkBlacklist();
        this.loadTable();
    }

    private void delFilter_() {
        this.mVFilter.get_jComboBoxFilterSender().setModel(new DefaultComboBoxModel<String>(Daten.listeFilmeNachBlackList.sender));
        this.mVFilter.get_jComboBoxFilterThema().setModel(new DefaultComboBoxModel<String>(this.getThemen("")));
        this.mVFilter.get_jTextFieldFilterTitel().setText("");
        this.mVFilter.get_jTextFieldFilterThemaTitel().setText("");
        this.mVFilter.setThemaTitel(true);
    }

    private void delFilterProfile(int filter) {
        Daten.mVConfig.add("filter-sender", String.valueOf(""), filter, 5);
        Daten.mVConfig.add("filter-thema", String.valueOf(""), filter, 5);
        Daten.mVConfig.add("filter-titel", String.valueOf(""), filter, 5);
        Daten.mVConfig.add("filter-themaTitel", String.valueOf(""), filter, 5);
        Daten.mVConfig.add("filter-TT-oder-irgendwo", Boolean.toString(true), filter, 5);
        Daten.mVConfig.add("filter-keineAbo", String.valueOf(false), filter, 5);
        Daten.mVConfig.add("filter-keineGesehen", String.valueOf(false), filter, 5);
        Daten.mVConfig.add("filter-nurHd", String.valueOf(false), filter, 5);
        Daten.mVConfig.add("filter-nurNeue", String.valueOf(false), filter, 5);
        Daten.mVConfig.add("filter-tage", "5", filter, 5);
        Daten.mVConfig.add("filter-dauer", "0", filter, 5);
        Daten.mVConfig.add("filter-blacklist-aus", Boolean.FALSE.toString(), filter, 5);
    }

    private void saveFilterProfile(int filter) {
        Daten.mVConfig.add("filter-sender", String.valueOf(this.mVFilter.get_jComboBoxFilterSender().getSelectedItem()), filter, 5);
        Daten.mVConfig.add("filter-thema", String.valueOf(this.mVFilter.get_jComboBoxFilterThema().getSelectedItem()), filter, 5);
        Daten.mVConfig.add("filter-titel", String.valueOf(this.mVFilter.get_jTextFieldFilterTitel().getText()), filter, 5);
        Daten.mVConfig.add("filter-themaTitel", String.valueOf(this.mVFilter.get_jTextFieldFilterThemaTitel().getText()), filter, 5);
        Daten.mVConfig.add("filter-TT-oder-irgendwo", Boolean.toString(this.mVFilter.getThemaTitel()), filter, 5);
        Daten.mVConfig.add("filter-keineAbo", String.valueOf(this.mVFilter.get_jCheckBoxKeineAbos().isSelected()), filter, 5);
        Daten.mVConfig.add("filter-keineGesehen", String.valueOf(this.mVFilter.get_jCheckBoxKeineGesehenen().isSelected()), filter, 5);
        Daten.mVConfig.add("filter-nurHd", String.valueOf(this.mVFilter.get_jCheckBoxNurHd().isSelected()), filter, 5);
        Daten.mVConfig.add("filter-nurNeue", String.valueOf(this.mVFilter.get_jCheckBoxNeue().isSelected()), filter, 5);
        Daten.mVConfig.add("filter-tage", String.valueOf(this.mVFilter.get_jComboBoxZeitraum().getSelectedIndex()), filter, 5);
        Daten.mVConfig.add("filter-dauer", String.valueOf(this.mVFilter.get_jSliderMinuten().getValue()), filter, 5);
    }

    public int getFilterTage() {
        return this.mVFilter.get_jComboBoxZeitraum().getSelectedIndex();
    }

    private String[] getThemen(String ssender) {
        for (int i = 1; i < Daten.listeFilmeNachBlackList.themenPerSender.length; ++i) {
            if (!Daten.listeFilmeNachBlackList.sender[i].equals(ssender)) continue;
            return Daten.listeFilmeNachBlackList.themenPerSender[i];
        }
        return Daten.listeFilmeNachBlackList.themenPerSender[0];
    }

    private synchronized void loadTable() {
        boolean themaNichtDa = false;
        try {
            this.stopBeob = true;
            this.tabelle.getSpalten();
            if (Daten.listeFilmeNachBlackList.isEmpty()) {
                this.delFilter_();
                this.listeInModellLaden();
            } else if (!Boolean.parseBoolean(Daten.mVConfig.get("Vis-Filter"))) {
                this.listeInModellLaden();
            } else {
                String filterThema = this.mVFilter.get_jComboBoxFilterThema().getSelectedItem().toString();
                String filterSender = this.mVFilter.get_jComboBoxFilterSender().getSelectedItem().toString();
                boolean themaOpen = this.mVFilter.get_jComboBoxFilterThema().isPopupVisible();
                boolean senderOpen = this.mVFilter.get_jComboBoxFilterSender().isPopupVisible();
                this.listeInModellLaden();
                this.mVFilter.get_jComboBoxFilterSender().setModel(new DefaultComboBoxModel<String>(Daten.listeFilmeNachBlackList.sender));
                this.mVFilter.get_jComboBoxFilterSender().setSelectedIndex(0);
                if (!filterSender.equals("")) {
                    this.mVFilter.get_jComboBoxFilterSender().setSelectedItem(filterSender);
                    if (this.mVFilter.get_jComboBoxFilterSender().getSelectedIndex() == 0) {
                        filterSender = "";
                        this.listeInModellLaden();
                    }
                }
                this.mVFilter.get_jComboBoxFilterSender().setPopupVisible(senderOpen);
                if (filterSender.equals("")) {
                    this.mVFilter.get_jComboBoxFilterThema().setModel(new DefaultComboBoxModel<String>(this.getThemen("")));
                } else {
                    this.mVFilter.get_jComboBoxFilterThema().setModel(new DefaultComboBoxModel<String>(this.getThemen(filterSender)));
                }
                this.mVFilter.get_jComboBoxFilterThema().setSelectedItem(filterThema);
                if (!filterThema.equals("") && this.mVFilter.get_jComboBoxFilterThema().getSelectedIndex() == 0) {
                    themaNichtDa = true;
                }
                this.mVFilter.get_jComboBoxFilterThema().setPopupVisible(themaOpen);
            }
            this.setInfo();
            this.tabelle.setSpalten();
            this.aktFilmSetzen();
            this.stopBeob = false;
            if (themaNichtDa) {
                this.loadTable();
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(558965421, ex);
        }
        this.tabelle.scrollToSelection();
    }

    private synchronized void listeInModellLaden() {
        ListeFilme lf = this.mVFilter.get_jToggleButtonHistory().isSelected() ? Daten.listeFilmeHistory : Daten.listeFilmeNachBlackList;
        if (Boolean.parseBoolean(Daten.mVConfig.get("Vis-Filter"))) {
            MVListeFilme.getModelTabFilme(lf, this.daten, this.tabelle, this.mVFilter.get_jComboBoxFilterSender().getSelectedItem().toString(), this.mVFilter.get_jComboBoxFilterThema().getSelectedItem().toString(), this.mVFilter.get_jTextFieldFilterTitel().getText(), this.mVFilter.getThemaTitel() ? this.mVFilter.get_jTextFieldFilterThemaTitel().getText() : "", this.mVFilter.getThemaTitel() ? "" : this.mVFilter.get_jTextFieldFilterThemaTitel().getText(), this.mVFilter.get_jSliderMinuten().getValue(), this.mVFilter.get_jCheckBoxKeineAbos().isSelected(), this.mVFilter.get_jCheckBoxKeineGesehenen().isSelected(), this.mVFilter.get_jCheckBoxNurHd().isSelected(), this.mVFilter.get_jToggleButtonLivestram().isSelected(), this.mVFilter.get_jCheckBoxNeue().isSelected());
        } else {
            MVListeFilme.getModelTabFilme(lf, this.daten, this.tabelle, "", "", "", this.daten.mediathekGui.getFilterTextFromSearchField(), "", this.mVFilter.get_jSliderMinuten().getValue(), this.mVFilter.get_jCheckBoxKeineAbos().isSelected(), this.mVFilter.get_jCheckBoxKeineGesehenen().isSelected(), this.mVFilter.get_jCheckBoxNurHd().isSelected(), this.mVFilter.get_jToggleButtonLivestram().isSelected(), this.mVFilter.get_jCheckBoxNeue().isSelected());
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        JPanel jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        JTable jTable1 = new JTable();
        this.jPanelBeschreibung = new JPanel();
        this.jPanelExtra = new JPanel();
        this.jCheckBoxProgamme = new JCheckBox();
        this.jPanelExtraInnen = new JPanel();
        this.jScrollPaneFilter = new JScrollPane();
        this.jPanelFilter = new JPanel();
        this.jSplitPane1.setDividerLocation(240);
        jTable1.setAutoCreateRowSorter(true);
        jTable1.setModel(new TModel());
        jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(jTable1);
        this.jPanelBeschreibung.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        GroupLayout jPanelBeschreibungLayout = new GroupLayout(this.jPanelBeschreibung);
        this.jPanelBeschreibung.setLayout(jPanelBeschreibungLayout);
        jPanelBeschreibungLayout.setHorizontalGroup(jPanelBeschreibungLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelBeschreibungLayout.setVerticalGroup(jPanelBeschreibungLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 128, Short.MAX_VALUE));
        this.jPanelExtra.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jCheckBoxProgamme.setFont(new Font("Dialog", 1, 10));
        this.jCheckBoxProgamme.setToolTipText("Buttons ausblenden");
        GroupLayout jPanelExtraInnenLayout = new GroupLayout(this.jPanelExtraInnen);
        this.jPanelExtraInnen.setLayout(jPanelExtraInnenLayout);
        jPanelExtraInnenLayout.setHorizontalGroup(jPanelExtraInnenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelExtraInnenLayout.setVerticalGroup(jPanelExtraInnenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExtraLayout.createSequentialGroup().addComponent(this.jCheckBoxProgamme).addGap(5, 5, 5).addComponent(this.jPanelExtraInnen, -1, -1, Short.MAX_VALUE).addGap(5, 5, 5)));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExtraLayout.createSequentialGroup().addGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExtraLayout.createSequentialGroup().addComponent(this.jCheckBoxProgamme).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanelExtraLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jPanelExtraInnen, -1, -1, Short.MAX_VALUE))).addGap(5, 5, 5)));
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelExtra, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelBeschreibung, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 612, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 337, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelBeschreibung, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelExtra, -2, -1, -2)));
        this.jSplitPane1.setRightComponent(jPanel1);
        GroupLayout jPanelFilterLayout = new GroupLayout(this.jPanelFilter);
        this.jPanelFilter.setLayout(jPanelFilterLayout);
        jPanelFilterLayout.setHorizontalGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 236, Short.MAX_VALUE));
        jPanelFilterLayout.setVerticalGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 504, Short.MAX_VALUE));
        this.jScrollPaneFilter.setViewportView(this.jPanelFilter);
        this.jSplitPane1.setLeftComponent(this.jScrollPaneFilter);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1));
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        private final BeobPrint beobPrint = new BeobPrint();
        private final BeobFilterLoeschen beobLoeschen = new BeobFilterLoeschen();
        private final BeobAbo beobAbo = new BeobAbo(false);
        private final BeobAbo beobAboMitTitel = new BeobAbo(true);
        private final BeobAboFilter beobAboFilter = new BeobAboFilter();
        private final BeobFilterThema beobThema = new BeobFilterThema();
        private final BeobFilterSender beobSender = new BeobFilterSender();
        private final BeobFilterSenderThema beobSenderThema = new BeobFilterSenderThema();
        private final BeobFilterSenderThemaTitel beobSenderThemaTitel = new BeobFilterSenderThemaTitel();
        private final BeobBlacklist beobBlacklistSender = new BeobBlacklist(true, false);
        private final BeobBlacklist beobBlacklistSenderThema = new BeobBlacklist(true, true);
        private final BeobBlacklist beobBlacklistThema = new BeobBlacklist(false, true);
        private Point p;
        private DatenFilm film = null;

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                if (arg0.getClickCount() == 1) {
                    this.p = arg0.getPoint();
                    int row = GuiFilme.this.tabelle.rowAtPoint(this.p);
                    int column = GuiFilme.this.tabelle.columnAtPoint(this.p);
                    if (row >= 0) {
                        this.buttonTable(row, column);
                    }
                } else if (arg0.getClickCount() > 1 && !GuiFilme.this.filmInfo.isVisible()) {
                    GuiFilme.this.filmInfo.showInfo();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void buttonTable(int row, int column) {
            if (row != -1) {
                if (GuiFilme.this.tabelle.convertColumnIndexToModel(column) == 4) {
                    DatenFilm datenFilm = GuiFilme.this.getSelFilm();
                    boolean stop = false;
                    DatenDownload datenDownload = Daten.listeDownloadsButton.getDownloadUrlFilm(datenFilm.arr[12]);
                    if (datenDownload != null && datenDownload.start != null && datenDownload.start.status == 2) {
                        stop = true;
                        Daten.listeDownloadsButton.delDownloadButton(datenFilm.arr[12]);
                    }
                    if (!stop) {
                        GuiFilme.this.playFilm();
                    }
                } else if (GuiFilme.this.tabelle.convertColumnIndexToModel(column) == 5) {
                    GuiFilme.this.saveFilm();
                }
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = GuiFilme.this.tabelle.rowAtPoint(this.p);
            if (nr >= 0) {
                GuiFilme.this.tabelle.setRowSelectionInterval(nr, nr);
            }
            this.film = GuiFilme.this.getFilm(nr);
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem item = new JMenuItem("Film abspielen");
            item.setIcon(GetIcon.getProgramIcon("film_start_16.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiFilme.this.playFilm();
                }
            });
            jPopupMenu.add(item);
            item = new JMenuItem("Film aufzeichnen");
            item.setIcon(GetIcon.getProgramIcon("film_rec_16.png"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiFilme.this.saveFilm();
                }
            });
            jPopupMenu.add(item);
            jPopupMenu.addSeparator();
            if (Boolean.parseBoolean(Daten.mVConfig.get("Vis-Filter"))) {
                JMenu submenueFilter = new JMenu("Filter");
                jPopupMenu.add(submenueFilter);
                item = new JMenuItem("Filter l\u00f6schen");
                item.addActionListener(this.beobLoeschen);
                submenueFilter.add(item);
                item = new JMenuItem("nach Sender filtern");
                item.addActionListener(this.beobSender);
                submenueFilter.add(item);
                item = new JMenuItem("nach Thema filtern");
                item.addActionListener(this.beobThema);
                submenueFilter.add(item);
                item = new JMenuItem("nach Sender und Thema filtern");
                item.addActionListener(this.beobSenderThema);
                submenueFilter.add(item);
                item = new JMenuItem("nach Sender, Thema und Titel filtern");
                item.addActionListener(this.beobSenderThemaTitel);
                submenueFilter.add(item);
            }
            JMenu submenueAbo = new JMenu("Abo");
            jPopupMenu.add(submenueAbo);
            JMenuItem itemAboLoeschen = new JMenuItem("Abo L\u00f6schen");
            JMenuItem itemAbo = new JMenuItem("Abo mit Sender und Thema anlegen");
            JMenuItem itemAboMitTitel = new JMenuItem("Abo mit Sender und Thema und Titel anlegen");
            JMenuItem itemAboFilter = new JMenuItem("Abo aus Filter anlegen");
            JMenuItem itemChangeAboFilter = new JMenuItem("Abo \u00e4ndern");
            if (this.film != null) {
                if (Daten.listeAbo.getAboFuerFilm_schnell(this.film, false) != null) {
                    itemAbo.setEnabled(false);
                    itemAboMitTitel.setEnabled(false);
                    itemAboFilter.setEnabled(false);
                    itemAboLoeschen.addActionListener(this.beobAbo);
                    itemChangeAboFilter.addActionListener(new BeobChangeAbo());
                } else {
                    itemAboLoeschen.setEnabled(false);
                    itemChangeAboFilter.setEnabled(false);
                    itemAbo.addActionListener(this.beobAbo);
                    itemAboMitTitel.addActionListener(this.beobAboMitTitel);
                    itemAboFilter.addActionListener(this.beobAboFilter);
                }
            }
            submenueAbo.add(itemAboLoeschen);
            submenueAbo.add(itemChangeAboFilter);
            submenueAbo.add(itemAbo);
            submenueAbo.add(itemAboMitTitel);
            submenueAbo.add(itemAboFilter);
            JMenu submenue = new JMenu("Film mit Set starten");
            jPopupMenu.add(submenue);
            ListePset liste = Daten.listePset.getListeButton();
            for (DatenPset pset : liste) {
                if (pset.getListeProg().isEmpty() && pset.arr[0].equals("")) continue;
                Color col = pset.getFarbe();
                item = new JMenuItem(pset.arr[0]);
                if (pset.getListeProg().isEmpty()) {
                    if (col != null) {
                        item.setForeground(col);
                    }
                } else {
                    item.addActionListener(new BeobOpen(pset));
                    if (col != null) {
                        item.setBackground(col);
                    }
                }
                submenue.add(item);
            }
            JMenu submenueBlack = new JMenu("Blacklist");
            jPopupMenu.add(submenueBlack);
            JMenuItem itemBlackSender = new JMenuItem("Sender in die Blacklist einf\u00fcgen");
            JMenuItem itemBlackThema = new JMenuItem("Thema in die Blacklist einf\u00fcgen");
            JMenuItem itemBlackSenderThema = new JMenuItem("Sender und Thema in die Blacklist einf\u00fcgen");
            itemBlackSender.addActionListener(this.beobBlacklistSender);
            itemBlackThema.addActionListener(this.beobBlacklistThema);
            itemBlackSenderThema.addActionListener(this.beobBlacklistSenderThema);
            submenueBlack.add(itemBlackSender);
            submenueBlack.add(itemBlackThema);
            submenueBlack.add(itemBlackSenderThema);
            submenueBlack.addSeparator();
            final JCheckBoxMenuItem jCheckBoxBlackBoxOn = new JCheckBoxMenuItem("Blacklist ist eingeschaltet");
            jCheckBoxBlackBoxOn.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Blacklist-ausgeschaltet")));
            jCheckBoxBlackBoxOn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Daten.mVConfig.add("Blacklist-ausgeschaltet", Boolean.toString(jCheckBoxBlackBoxOn.isSelected()));
                    MVListeFilme.checkBlacklist();
                    ListenerMediathekView.notify(39, GuiFilme.class.getName());
                }
            });
            submenueBlack.add(jCheckBoxBlackBoxOn);
            final JCheckBoxMenuItem jCheckBoxBlackBoxStart = new JCheckBoxMenuItem("Blacklist ist beim Programmstart eingeschaltet");
            jCheckBoxBlackBoxStart.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Blacklist-Start-ausgeschaltet")));
            jCheckBoxBlackBoxStart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Daten.mVConfig.add("Blacklist-Start-ausgeschaltet", Boolean.toString(jCheckBoxBlackBoxStart.isSelected()));
                    ListenerMediathekView.notify(40, GuiFilme.class.getName());
                }
            });
            submenueBlack.add(jCheckBoxBlackBoxStart);
            if (this.film != null) {
                String uNormal = this.film.getUrlFuerAufloesung("normal");
                String uHd = this.film.getUrlFuerAufloesung("hd");
                String uLow = this.film.getUrlFuerAufloesung("klein");
                if (uHd.equals(uNormal)) {
                    uHd = "";
                }
                if (uLow.equals(uNormal)) {
                    uLow = "";
                }
                if (!uNormal.isEmpty()) {
                    jPopupMenu.addSeparator();
                    if (!uHd.isEmpty() || !uLow.isEmpty()) {
                        JMenu submenueURL = new JMenu("Film-URL kopieren");
                        if (!uHd.isEmpty()) {
                            item = new JMenuItem("in HD-Aufl\u00f6sung");
                            KeyStroke ctrlH = KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
                            item.setAccelerator(ctrlH);
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    GuiFunktionen.copyToClipboard(BeobMausTabelle.this.film.getUrlFuerAufloesung("hd"));
                                }
                            });
                            submenueURL.add(item);
                        }
                        item = new JMenuItem("in hoher Aufl\u00f6sung");
                        KeyStroke ctrlU = KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
                        item.setAccelerator(ctrlU);
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                GuiFunktionen.copyToClipboard(BeobMausTabelle.this.film.getUrlFuerAufloesung("normal"));
                            }
                        });
                        submenueURL.add(item);
                        if (!uLow.isEmpty()) {
                            item = new JMenuItem("in geringer Aufl\u00f6sung");
                            KeyStroke ctrlK = KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
                            item.setAccelerator(ctrlK);
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    GuiFunktionen.copyToClipboard(BeobMausTabelle.this.film.getUrlFuerAufloesung("klein"));
                                }
                            });
                            submenueURL.add(item);
                        }
                        jPopupMenu.add(submenueURL);
                    } else {
                        item = new JMenuItem("Film-URL kopieren");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                GuiFunktionen.copyToClipboard(BeobMausTabelle.this.film.getUrlFuerAufloesung("normal"));
                            }
                        });
                        jPopupMenu.add(item);
                    }
                }
            }
            jPopupMenu.addSeparator();
            if (this.film != null) {
                JMenuItem itemDb = new JMenuItem("Titel in der Mediensammlung suchen");
                itemDb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GuiFilme.this.mediensammlung();
                    }
                });
                jPopupMenu.add(itemDb);
            }
            item = new JMenuItem("Tabelle drucken");
            item.addActionListener(this.beobPrint);
            jPopupMenu.add(item);
            item = new JMenuItem("Filminformation anzeigen");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!GuiFilme.this.filmInfo.isVisible()) {
                        GuiFilme.this.filmInfo.showInfo();
                    }
                }
            });
            jPopupMenu.add(item);
            if (this.film != null) {
                if (GuiFilme.this.daten.history.urlPruefen(this.film.getUrlHistory())) {
                    item = new JMenuItem("Film als ungesehen markieren");
                    item.addActionListener(new BeobHistory(false));
                } else {
                    item = new JMenuItem("Film als gesehen markieren");
                    item.addActionListener(new BeobHistory(true));
                }
                jPopupMenu.add(item);
            }
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private String getThemaFilter(String sender, String thema) {
            String ret = "";
            for (int i = 1; i < Daten.listeFilmeNachBlackList.themenPerSender.length; ++i) {
                if (!Daten.listeFilmeNachBlackList.sender[i].equals(sender)) continue;
                for (int k = 1; k < Daten.listeFilmeNachBlackList.themenPerSender[i].length; ++k) {
                    if (!Daten.listeFilmeNachBlackList.themenPerSender[i][k].equalsIgnoreCase(thema)) continue;
                    ret = Daten.listeFilmeNachBlackList.themenPerSender[i][k];
                }
            }
            return ret;
        }

        private class BeobBlacklist
        implements ActionListener {
            boolean sender;
            boolean thema;

            public BeobBlacklist(boolean ssender, boolean tthema) {
                this.sender = ssender;
                this.thema = tthema;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    DatenFilm film = GuiFilme.this.getFilm(nr);
                    String th = film.arr[2];
                    String se = film.arr[1];
                    Daten.mVConfig.add("Blacklist-ausgeschaltet", Boolean.TRUE.toString());
                    if (!this.sender) {
                        Daten.listeBlacklist.add(new DatenBlacklist("", th, "", ""));
                    } else if (!this.thema) {
                        Daten.listeBlacklist.add(new DatenBlacklist(se, "", "", ""));
                    } else {
                        Daten.listeBlacklist.add(new DatenBlacklist(se, th, "", ""));
                    }
                }
            }
        }

        private class BeobAboFilter
        implements ActionListener {
            private BeobAboFilter() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Daten.listePset.getListeAbo().isEmpty()) {
                    MVMessageDialog.showMessageDialog(GuiFilme.this.parentComponent, "Im Men\u00fc unter \"Datei->Optionen->Videoplayer\" ein Programm zum Aufzeichnen festlegen.", "kein Videoplayer!", 1);
                } else {
                    int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                    if (nr >= 0) {
                        GuiFilme.this.stopBeob = true;
                        DatenFilm film = GuiFilme.this.getFilm(nr);
                        String thema = film.arr[2];
                        Daten.listeAbo.addAbo(GuiFilme.this.mVFilter.get_jComboBoxFilterSender().getSelectedItem().toString(), GuiFilme.this.mVFilter.get_jComboBoxFilterThema().getSelectedItem().toString(), GuiFilme.this.mVFilter.get_jTextFieldFilterTitel().getText(), GuiFilme.this.mVFilter.getThemaTitel() ? GuiFilme.this.mVFilter.get_jTextFieldFilterThemaTitel().getText() : "", GuiFilme.this.mVFilter.getThemaTitel() ? "" : GuiFilme.this.mVFilter.get_jTextFieldFilterThemaTitel().getText(), GuiFilme.this.mVFilter.get_jSliderMinuten().getValue(), thema);
                        GuiFilme.this.stopBeob = false;
                    }
                }
            }
        }

        private class BeobAbo
        implements ActionListener {
            boolean mitTitel = false;

            public BeobAbo(boolean mmitTitel) {
                this.mitTitel = mmitTitel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Daten.listePset.getListeAbo().isEmpty()) {
                    MVMessageDialog.showMessageDialog(GuiFilme.this.parentComponent, "Im Men\u00fc unter \"Datei->Optionen->Videoplayer\" ein Programm zum Aufzeichnen festlegen.", "kein Videoplayer!", 1);
                } else {
                    int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                    if (nr >= 0) {
                        GuiFilme.this.stopBeob = true;
                        DatenFilm film = GuiFilme.this.getFilm(nr);
                        if (film != null) {
                            DatenAbo datenAbo = Daten.listeAbo.getAboFuerFilm_schnell(film, false);
                            if (datenAbo != null) {
                                Daten.listeAbo.aboLoeschen(datenAbo);
                            } else if (this.mitTitel) {
                                Daten.listeAbo.addAbo(film.arr[2], film.arr[1], film.arr[2], film.arr[3]);
                            } else {
                                Daten.listeAbo.addAbo(film.arr[2], film.arr[1], film.arr[2], "");
                            }
                        }
                        GuiFilme.this.stopBeob = false;
                    }
                }
            }
        }

        private class BeobChangeAbo
        implements ActionListener {
            private BeobChangeAbo() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Daten.listePset.getListeAbo().isEmpty()) {
                    MVMessageDialog.showMessageDialog(GuiFilme.this.parentComponent, "Im Men\u00fc unter \"Datei->Optionen->Videoplayer\" ein Programm zum Aufzeichnen festlegen.", "kein Videoplayer!", 1);
                } else {
                    int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                    if (nr >= 0) {
                        DatenAbo datenAbo;
                        GuiFilme.this.stopBeob = true;
                        DatenFilm film = GuiFilme.this.getFilm(nr);
                        if (film != null && (datenAbo = Daten.listeAbo.getAboFuerFilm_schnell(film, false)) != null) {
                            DialogEditAbo dialog = new DialogEditAbo(GuiFilme.this.daten.mediathekGui, true, GuiFilme.this.daten, datenAbo);
                            dialog.setVisible(true);
                            if (dialog.ok) {
                                Daten.listeAbo.aenderungMelden();
                            }
                        }
                        GuiFilme.this.stopBeob = false;
                    }
                }
            }
        }

        private class BeobFilterLoeschen
        implements ActionListener {
            private BeobFilterLoeschen() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFilme.this.guiFilmeFilterLoeschen();
            }
        }

        private class BeobFilterSenderThemaTitel
        implements ActionListener {
            private BeobFilterSenderThemaTitel() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    DatenFilm film = GuiFilme.this.getFilm(nr);
                    String sen = film.arr[1];
                    GuiFilme.this.mVFilter.get_jComboBoxFilterSender().setSelectedIndex(0);
                    GuiFilme.this.mVFilter.get_jComboBoxFilterSender().setSelectedItem(sen);
                    String thema = film.arr[2];
                    GuiFilme.this.mVFilter.get_jComboBoxFilterThema().setSelectedIndex(0);
                    GuiFilme.this.mVFilter.get_jComboBoxFilterThema().setSelectedItem(thema);
                    if (GuiFilme.this.mVFilter.get_jComboBoxFilterThema().getSelectedIndex() == 0) {
                        String themaFilter = BeobMausTabelle.this.getThemaFilter(sen, thema);
                        GuiFilme.this.mVFilter.get_jComboBoxFilterThema().setSelectedItem(themaFilter);
                    }
                    String tit = film.arr[3];
                    GuiFilme.this.mVFilter.get_jTextFieldFilterTitel().setText(tit);
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.loadTable();
                }
            }
        }

        private class BeobFilterSenderThema
        implements ActionListener {
            private BeobFilterSenderThema() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    DatenFilm film = GuiFilme.this.getFilm(nr);
                    String sen = film.arr[1];
                    GuiFilme.this.mVFilter.get_jComboBoxFilterSender().setSelectedIndex(0);
                    GuiFilme.this.mVFilter.get_jComboBoxFilterSender().setSelectedItem(sen);
                    String thema = film.arr[2];
                    GuiFilme.this.mVFilter.get_jComboBoxFilterThema().setSelectedIndex(0);
                    GuiFilme.this.mVFilter.get_jComboBoxFilterThema().setSelectedItem(thema);
                    if (GuiFilme.this.mVFilter.get_jComboBoxFilterThema().getSelectedIndex() == 0) {
                        String themaFilter = BeobMausTabelle.this.getThemaFilter(sen, thema);
                        GuiFilme.this.mVFilter.get_jComboBoxFilterThema().setSelectedItem(themaFilter);
                    }
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.loadTable();
                }
            }
        }

        private class BeobFilterSender
        implements ActionListener {
            private BeobFilterSender() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    DatenFilm film = GuiFilme.this.getFilm(nr);
                    String sen = film.arr[1];
                    GuiFilme.this.mVFilter.get_jComboBoxFilterSender().setSelectedIndex(0);
                    GuiFilme.this.mVFilter.get_jComboBoxFilterSender().setSelectedItem(sen);
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.loadTable();
                }
            }
        }

        private class BeobFilterThema
        implements ActionListener {
            private BeobFilterThema() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    DatenFilm film = GuiFilme.this.getFilm(nr);
                    String thema = film.arr[2];
                    GuiFilme.this.mVFilter.get_jComboBoxFilterThema().setSelectedIndex(0);
                    GuiFilme.this.mVFilter.get_jComboBoxFilterThema().setSelectedItem(thema);
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.loadTable();
                }
            }
        }

        private class BeobPrint
        implements ActionListener {
            private BeobPrint() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GuiFilme.this.tabelle.print();
                }
                catch (PrinterException ex) {
                    Log.fehlerMeldung(688542239, ex);
                }
            }
        }

        private class BeobHistory
        implements ActionListener {
            boolean eintragen;

            public BeobHistory(boolean eeintragen) {
                this.eintragen = eeintragen;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    DatenFilm film = GuiFilme.this.getFilm(nr);
                    if (this.eintragen) {
                        GuiFilme.this.daten.history.zeileSchreiben(film.arr[2], film.arr[3], film.getUrlHistory());
                        Daten.listeFilmeHistory.add((Object)film);
                    } else {
                        GuiFilme.this.daten.history.urlAusLogfileLoeschen(film.getUrlHistory());
                        Daten.listeFilmeHistory.remove((Object)film);
                    }
                }
            }
        }
    }

    private class BeobFilterTitelDoc
    implements DocumentListener {
        private BeobFilterTitelDoc() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tus();
        }

        private void tus() {
            Filter.checkPattern1(GuiFilme.this.mVFilter.get_jTextFieldFilterThemaTitel());
            Filter.checkPattern1(GuiFilme.this.mVFilter.get_jTextFieldFilterTitel());
            if (Boolean.parseBoolean(Daten.mVConfig.get("Echtzeitsuche"))) {
                GuiFilme.this.loadTable();
            }
        }
    }

    private class BeobachterTableSelect
    implements ListSelectionListener {
        private BeobachterTableSelect() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting() && !GuiFilme.this.stopBeob) {
                GuiFilme.this.aktFilmSetzen();
            }
        }
    }

    private class BeobFilterLoeschen
    implements ActionListener {
        private BeobFilterLoeschen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.guiFilmeFilterLoeschen();
        }
    }

    private class BeobFilter
    implements ActionListener {
        private BeobFilter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!GuiFilme.this.stopBeob) {
                GuiFilme.this.loadTable();
            }
        }
    }

    private class BeobOpen
    implements ActionListener {
        DatenPset pset;

        public BeobOpen(DatenPset p) {
            this.pset = p;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.playerStarten(this.pset);
        }
    }
}

