/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class RolloverProducer
implements MouseListener,
MouseMotionListener,
ComponentListener {
    private static final Logger LOG = Logger.getLogger(RolloverProducer.class.getName());
    public static final String CLICKED_KEY = "swingx.clicked";
    public static final String ROLLOVER_KEY = "swingx.rollover";
    private boolean isDragging;
    protected Point rollover = new Point(-1, -1);

    public void install(JComponent component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addComponentListener(this);
    }

    public void release(JComponent component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        component.removeComponentListener(this);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Point oldCell = new Point(this.rollover);
        this.updateRollover(e, ROLLOVER_KEY, false);
        if (this.isClick(e, oldCell, this.isDragging)) {
            this.updateRollover(e, CLICKED_KEY, true);
        }
        this.isDragging = false;
    }

    protected boolean isClick(MouseEvent e, Point oldRollover, boolean wasDragging) {
        return oldRollover.equals(this.rollover);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.isDragging = false;
        this.updateRollover(e, ROLLOVER_KEY, false);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isDragging = false;
        ((JComponent)e.getSource()).putClientProperty(ROLLOVER_KEY, null);
        ((JComponent)e.getSource()).putClientProperty(CLICKED_KEY, null);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.isDragging = true;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateRollover(e, ROLLOVER_KEY, false);
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateRollover(e);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.updateRollover(e);
    }

    private void updateRollover(ComponentEvent e) {
        Point componentLocation;
        block5: {
            componentLocation = null;
            try {
                componentLocation = e.getComponent().getMousePosition();
            }
            catch (ClassCastException ignore) {
                Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                if (w == null || !SwingUtilities.isDescendingFrom(e.getComponent(), w)) break block5;
                try {
                    PointerInfo pi = AccessController.doPrivileged(new PrivilegedAction<PointerInfo>(){

                        @Override
                        public PointerInfo run() {
                            return MouseInfo.getPointerInfo();
                        }
                    });
                    componentLocation = pi.getLocation();
                    SwingUtilities.convertPointFromScreen(componentLocation, e.getComponent());
                }
                catch (SecurityException se) {
                    // empty catch block
                }
            }
        }
        if (componentLocation == null) {
            componentLocation = new Point(-1, -1);
        }
        this.updateRolloverPoint((JComponent)e.getComponent(), componentLocation);
        this.updateClientProperty((JComponent)e.getComponent(), ROLLOVER_KEY, true);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    protected void updateRollover(MouseEvent e, String property, boolean fireAlways) {
        this.updateRolloverPoint((JComponent)e.getComponent(), e.getPoint());
        this.updateClientProperty((JComponent)e.getComponent(), property, fireAlways);
    }

    protected void updateClientProperty(JComponent component, String property, boolean fireAlways) {
        if (fireAlways) {
            component.putClientProperty(property, null);
            component.putClientProperty(property, new Point(this.rollover));
        } else {
            Point p = (Point)component.getClientProperty(property);
            if (p == null || this.rollover.x != p.x || this.rollover.y != p.y) {
                component.putClientProperty(property, new Point(this.rollover));
            }
        }
    }

    protected abstract void updateRolloverPoint(JComponent var1, Point var2);
}

