/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmlisten;

import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import msearch.daten.ListeFilme;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;
import msearch.filmlisten.MSFilmlisteLesen;
import msearch.filmlisten.MSFilmlistenSuchen;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;

public class MSImportFilmliste {
    private EventListenerList listeners = new EventListenerList();
    private final MSFilmlisteLesen msFilmlisteLesen = new MSFilmlisteLesen();
    public MSFilmlistenSuchen msFilmlistenSuchen = new MSFilmlistenSuchen();

    public MSImportFilmliste() {
        this.msFilmlisteLesen.addAdListener(new MSListenerFilmeLaden(){

            @Override
            public synchronized void start(MSListenerFilmeLadenEvent event) {
                for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])MSImportFilmliste.this.listeners.getListeners(MSListenerFilmeLaden.class)) {
                    l.start(event);
                }
            }

            @Override
            public synchronized void progress(MSListenerFilmeLadenEvent event) {
                for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])MSImportFilmliste.this.listeners.getListeners(MSListenerFilmeLaden.class)) {
                    l.progress(event);
                }
            }

            @Override
            public synchronized void fertig(MSListenerFilmeLadenEvent event) {
            }
        });
    }

    public void filmeImportierenAuto(ListeFilme listeFilme, ListeFilme listeFilmeDiff, int days) {
        MSConfig.setStop(false);
        new Thread(new FilmeImportierenAutoThread(listeFilme, listeFilmeDiff, days)).start();
    }

    public void filmeImportierenDatei(String pfad, ListeFilme listeFilme, int days) {
        MSConfig.setStop(false);
        new Thread(new FilmeImportierenDateiThread(pfad, listeFilme, days)).start();
    }

    public void addAdListener(MSListenerFilmeLaden listener) {
        this.listeners.add(MSListenerFilmeLaden.class, listener);
    }

    public void updateDownloadUrlsFilmlisten(boolean akt) {
        this.msFilmlistenSuchen.updateURLsFilmlisten(akt);
    }

    private boolean urlLaden(String dateiUrl, ListeFilme listeFilme, int days) {
        boolean ret = false;
        try {
            if (!dateiUrl.equals("")) {
                MSLog.systemMeldung("Filmliste laden von: " + dateiUrl);
                this.msFilmlisteLesen.readFilmListe(dateiUrl, listeFilme, days);
                if (!listeFilme.isEmpty()) {
                    ret = true;
                }
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(965412378, ex);
        }
        return ret;
    }

    private synchronized void fertigMelden(boolean ok) {
        for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])this.listeners.getListeners(MSListenerFilmeLaden.class)) {
            l.fertig(new MSListenerFilmeLadenEvent("", "", 0, 0, 0, !ok));
        }
    }

    private class FilmeImportierenDateiThread
    implements Runnable {
        private final String pfad;
        private final ListeFilme listeFilme;
        private final int days;

        public FilmeImportierenDateiThread(String pfad, ListeFilme listeFilme, int days) {
            this.pfad = pfad;
            this.listeFilme = listeFilme;
            this.days = days;
        }

        @Override
        public void run() {
            MSImportFilmliste.this.fertigMelden(MSImportFilmliste.this.urlLaden(this.pfad, this.listeFilme, this.days));
        }
    }

    private class FilmeImportierenAutoThread
    implements Runnable {
        private final ListeFilme listeFilme;
        private final ListeFilme listeFilmeDiff;
        private final int STATE_AKT = 2;
        private final int STATE_DIFF = 3;
        private int state;
        private int days;

        public FilmeImportierenAutoThread(ListeFilme listeFilme, ListeFilme listeFilmeDiff, int days) {
            this.listeFilme = listeFilme;
            this.listeFilmeDiff = listeFilmeDiff;
            this.days = days;
        }

        @Override
        public void run() {
            boolean ret;
            if (this.listeFilme.isTooOldForDiff()) {
                this.state = 2;
                this.listeFilme.clear();
                ret = this.suchenAktListe(this.listeFilme);
            } else {
                this.state = 3;
                ret = this.suchenAktListe(this.listeFilmeDiff);
                if (!ret || this.listeFilmeDiff.isEmpty()) {
                    this.state = 2;
                    this.listeFilme.clear();
                    this.listeFilmeDiff.clear();
                    ret = this.suchenAktListe(this.listeFilme);
                }
            }
            if (!ret) {
                MSLog.fehlerMeldung(951235497, "Es konnten keine Filme geladen werden!");
            }
            MSImportFilmliste.this.fertigMelden(ret);
        }

        private boolean suchenAktListe(ListeFilme liste) {
            boolean ret = false;
            ArrayList<String> versuchteUrls = new ArrayList<String>();
            String updateUrl = "";
            switch (this.state) {
                case 2: {
                    updateUrl = MSImportFilmliste.this.msFilmlistenSuchen.suchenAkt(versuchteUrls);
                    break;
                }
                case 3: {
                    updateUrl = MSImportFilmliste.this.msFilmlistenSuchen.suchenDiff(versuchteUrls);
                }
            }
            if (updateUrl.isEmpty()) {
                return false;
            }
            int max = this.state == 3 ? 2 : 5;
            for (int i = 0; i < max; ++i) {
                switch (this.state) {
                    case 2: {
                        ret = MSImportFilmliste.this.urlLaden(updateUrl, liste, this.days);
                        break;
                    }
                    case 3: {
                        ret = MSImportFilmliste.this.urlLaden(updateUrl, liste, this.days);
                    }
                }
                if (ret && i < 1 && liste.isOlderThan(18000)) {
                    MSLog.systemMeldung("Filmliste zu alt, neuer Versuch");
                    ret = false;
                }
                if (ret) {
                    return true;
                }
                switch (this.state) {
                    case 2: {
                        updateUrl = MSImportFilmliste.this.msFilmlistenSuchen.listeFilmlistenUrls_akt.getRand(versuchteUrls);
                        break;
                    }
                    case 3: {
                        updateUrl = MSImportFilmliste.this.msFilmlistenSuchen.listeFilmlistenUrls_diff.getRand(versuchteUrls);
                    }
                }
                versuchteUrls.add(updateUrl);
                if (MSConfig.getStop()) break;
            }
            return ret;
        }
    }
}

