/*
 * Decompiled with CFR 0.152.
 */
package msearch.tool;

import java.io.File;
import java.security.CodeSource;
import java.util.ResourceBundle;
import msearch.Main;
import msearch.daten.DatenFilm;
import msearch.tool.MSLog;
import org.apache.commons.lang3.StringEscapeUtils;

public class MSFunktionen {
    public static final int OS_UNKNOWN = 0;
    public static final int OS_WIN_32BIT = 1;
    public static final int OS_WIN_64BIT = 2;
    public static final int OS_LINUX = 3;
    public static final int OS_MAC = 4;
    public static final String OS_UNKNOWN_STRING = "";
    public static final String OS_WIN_32BIT_STRING = "Windows";
    public static final String OS_WIN_64BIT_STRING = "Windows";
    public static final String OS_LINUX_STRING = "Linux";
    public static final String OS_MAC_STRING = "Mac";

    public static String getPathJar() {
        String s;
        String pFilePath = "pFile";
        File propFile = new File(pFilePath);
        if (!propFile.exists()) {
            try {
                CodeSource cS = Main.class.getProtectionDomain().getCodeSource();
                File jarFile = new File(cS.getLocation().toURI().getPath());
                String jarDir = jarFile.getParentFile().getPath();
                propFile = new File(jarDir + File.separator + pFilePath);
            }
            catch (Exception cS) {
                // empty catch block
            }
        }
        if (!(s = propFile.getAbsolutePath().replace(pFilePath, OS_UNKNOWN_STRING)).endsWith(File.separator)) {
            s = s + File.separator;
        }
        return s;
    }

    public static String getProgVersionString() {
        return " [Rel: " + MSFunktionen.getBuildNr() + "]";
    }

    public static String[] getJavaVersion() {
        String[] ret = new String[4];
        int i = 0;
        ret[i++] = "Vendor: " + System.getProperty("java.vendor");
        ret[i++] = "VMname: " + System.getProperty("java.vm.name");
        ret[i++] = "Version: " + System.getProperty("java.version");
        ret[i++] = "Runtimeversion: " + System.getProperty("java.runtime.version");
        return ret;
    }

    public static String getCompileDate() {
        String propToken = "DATE";
        String msg = OS_UNKNOWN_STRING;
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle("version");
            msg = rb.getString(propToken);
        }
        catch (Exception e) {
            MSLog.fehlerMeldung(807293847, e);
        }
        return msg;
    }

    public static String getBuildNr() {
        String propToken = "BUILD";
        String msg = OS_UNKNOWN_STRING;
        try {
            ResourceBundle.clearCache();
            ResourceBundle rb = ResourceBundle.getBundle("version");
            msg = rb.getString(propToken);
        }
        catch (Exception e) {
            MSLog.fehlerMeldung(134679898, e);
        }
        return msg;
    }

    public static void unescape(DatenFilm film) {
        film.arr[2] = StringEscapeUtils.unescapeXml(film.arr[2].trim());
        film.arr[2] = StringEscapeUtils.unescapeHtml4(film.arr[2].trim());
        film.arr[10] = StringEscapeUtils.unescapeXml(film.arr[10].trim());
        film.arr[10] = StringEscapeUtils.unescapeHtml4(film.arr[10].trim());
        film.arr[10] = MSFunktionen.removeHtml(film.arr[10]);
        film.arr[3] = StringEscapeUtils.unescapeXml(film.arr[3].trim());
        film.arr[3] = StringEscapeUtils.unescapeHtml4(film.arr[3].trim());
    }

    public static String utf8(String ret) {
        ret = ret.replace("\\u0026", "&");
        ret = ret.replace("\\u003C", "<");
        ret = ret.replace("\\u003c", "<");
        ret = ret.replace("\\u003E", ">");
        ret = ret.replace("\\u003e", ">");
        ret = ret.replace("\\u00E4", "\u00e4");
        ret = ret.replace("\\u00e4", "\u00e4");
        ret = ret.replace("\\u00C4", "\u00c4");
        ret = ret.replace("\\u00c4", "\u00c4");
        ret = ret.replace("\\u00F6", "\u00f6");
        ret = ret.replace("\\u00f6", "\u00f6");
        ret = ret.replace("\\u00D6", "\u00d6");
        ret = ret.replace("\\u00d6", "\u00d6");
        ret = ret.replace("\\u00FC", "\u00fc");
        ret = ret.replace("\\u00fc", "\u00fc");
        ret = ret.replace("\\u00DC", "\u00dc");
        ret = ret.replace("\\u00dc", "\u00dc");
        ret = ret.replace("\\u00DF", "\u00df");
        ret = ret.replace("\\u00df", "\u00df");
        ret = ret.replace("\\u20AC", "\u20ac");
        ret = ret.replace("\\u20ac", "\u20ac");
        ret = ret.replace("\\u0024", "$");
        ret = ret.replace("\\u00A3", "\u00a3");
        ret = ret.replace("\\u00a3", "\u00a3");
        ret = ret.replace("\\u00F3", "\u00f3");
        ret = ret.replace("\\u00f3", "\u00f3");
        return ret;
    }

    public static String cleanUnicode(String ret, String sonst) {
        String r = OS_UNKNOWN_STRING;
        for (int i = 0; i < ret.length(); ++i) {
            char c = ret.charAt(i);
            char hex = ret.charAt(i);
            if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN) {
                r = r + c;
                continue;
            }
            if (c == '\u00c4' || c == '\u00d6' || c == '\u00dc' || c == '\u00e4' || c == '\u00f6' || c == '\u00fc') {
                r = r + c;
                continue;
            }
            if (c == '\u00df') {
                r = r + "\u00df";
                continue;
            }
            if (c == '\u00c2' || c == '\u00c0' || c == '\u00c5' || c == '\u00c1') {
                r = r + "A";
                continue;
            }
            if (c == '\u00e5' || c == '\u00e1' || c == '\u00e0' || c == '\u00e2') {
                r = r + "a";
                continue;
            }
            if (c == '\u010c' || c == '\u010c') {
                r = r + "C";
                continue;
            }
            if (c == '\u0107' || c == '\u010d' || c == '\u00e7') {
                r = r + "c";
                continue;
            }
            if (c == '\u0110') {
                r = r + "D";
                continue;
            }
            if (c == '\u00c9' || c == '\u00c8') {
                r = r + "E";
                continue;
            }
            if (c == '\u00e9' || c == '\u00e8' || c == '\u00ea' || c == '\u011b' || c == '\u00eb') {
                r = r + "e";
                continue;
            }
            if (c == '\u00ed') {
                r = r + "i";
                continue;
            }
            if (c == '\u00f1') {
                r = r + "n";
                continue;
            }
            if (c == '\u00f3' || c == '\u00f4' || c == '\u00f8') {
                r = r + "o";
                continue;
            }
            if (c == '\u0160') {
                r = r + "S";
                continue;
            }
            if (c == '\u015b' || c == '\u0161' || c == '\u015f') {
                r = r + "s";
                continue;
            }
            if (c == '\u0142' || c == '\u0141') {
                r = r + "t";
                continue;
            }
            if (c == '\u00fb' || c == '\u00f9') {
                r = r + "u";
                continue;
            }
            if (c == '\u00fd') {
                r = r + "y";
                continue;
            }
            if (c == '\u017d' || c == '\u0179') {
                r = r + "Z";
                continue;
            }
            if (c == '\u017e' || c == '\u017a') {
                r = r + "z";
                continue;
            }
            if (c == '\u00e6') {
                r = r + "ae";
                continue;
            }
            if (c == '\n') continue;
            if (c == '\u2013') {
                r = r + "-";
                continue;
            }
            if (c == '\u201e') {
                r = r + "\"";
                continue;
            }
            if (c == '\u201e' || c == '\u201d' || c == '\u201c' || c == '\u00ab' || c == '\u00bb') {
                r = r + "\"";
                continue;
            }
            if (c == '?') {
                r = r + "?";
                continue;
            }
            if (c == '\u00b0' || c == '\u2122') {
                r = r + OS_UNKNOWN_STRING;
                continue;
            }
            if (c == '\u2026') {
                r = r + "...";
                continue;
            }
            if (c == '\u20ac') {
                r = r + "\u20ac";
                continue;
            }
            if (c == '\u00b4' || c == '\u2019' || c == '\u2018' || c == '\u00bf') {
                r = r + "'";
                continue;
            }
            if (c == '?') {
                r = r + "?";
                continue;
            }
            if (c == '\u0096') {
                r = r + "-";
                continue;
            }
            if (c == '\u0085' || c == '\u0080' || c == '\u0084' || c == '\u0092' || c == '\u0093') continue;
            r = c == '\u0091' ? r + "-" : r + sonst;
        }
        return r;
    }

    public static String addsPfad(String pfad1, String pfad2) {
        String ret = OS_UNKNOWN_STRING;
        if (pfad1 != null && pfad2 != null) {
            if (pfad1.isEmpty()) {
                ret = pfad2;
            } else if (pfad2.isEmpty()) {
                ret = pfad1;
            } else if (!pfad1.equals(OS_UNKNOWN_STRING) && !pfad2.equals(OS_UNKNOWN_STRING)) {
                ret = pfad1.endsWith(File.separator) ? pfad1.substring(0, pfad1.length() - 1) : pfad1;
                ret = pfad2.charAt(0) == File.separatorChar ? ret + pfad2 : ret + File.separator + pfad2;
            }
        }
        if (ret.equals(OS_UNKNOWN_STRING)) {
            MSLog.fehlerMeldung(283946015, pfad1 + " - " + pfad2);
        }
        return ret;
    }

    public static String addUrl(String u1, String u2) {
        if (u1.endsWith("/")) {
            return u1 + u2;
        }
        return u1 + "/" + u2;
    }

    public static boolean istUrl(String dateiUrl) {
        return dateiUrl.startsWith("http") || dateiUrl.startsWith("www");
    }

    public static String getDateiName(String pfad) {
        String ret = OS_UNKNOWN_STRING;
        if (pfad != null && !pfad.equals(OS_UNKNOWN_STRING)) {
            ret = pfad.substring(pfad.lastIndexOf("/") + 1);
        }
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf("?"));
        }
        if (ret.contains("&")) {
            ret = ret.substring(0, ret.indexOf("&"));
        }
        if (ret.equals(OS_UNKNOWN_STRING)) {
            MSLog.fehlerMeldung(395019631, pfad);
        }
        return ret;
    }

    public static String removeHtml(String in) {
        return in.replaceAll("\\<.*?>", OS_UNKNOWN_STRING);
    }
}

